<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function cart()
    {
        return $this->hasMany('\Cart');
    }

    public function order()
    {
        return $this->hasMany('\Order');
    }

    public function shipping_info()
    {
        return $this->hasMany('\ShippingInformation');
    }

}